
package kom.itbeankit.common;


import java.util.Hashtable;
import java.util.Enumeration;
import java.io.*;


/**
  * DataPool is an Extension of Hashtable. It is used for the storage
  * of the relevant Data of every Bean. TO STORE DATA USE PUT(STRING FILENAME, OBJECT DATA) 
  * which is already implemented in Hashtable !!!!
  */

public class DataPool extends java.util.Hashtable
{
	/** Parameter for saving the data
	*   @value true the data can / should be saved
	*   @value false the data cant /shouldnt be saved
	*/

	protected boolean save=true;

    /** Standard Constructor
    */
	public  DataPool()
	{
	}
	/**
	  * Returns the save-variable which says wheather data should / can be saved (true) or not
	 */

	public boolean getSaving()
	{
		return this.save;
	}
	/** This method saves all data in Storage on Disk.
	  * The filename is the key-value in the hashtable and
	  * the Object is the value corresponding to it.
	  * The keys are determined by the ItFileName Class
	  */

	public void save()
	{
		for (Enumeration e=keys();e.hasMoreElements();)
			{
			 Object temp=e.nextElement();
			 File f=new File((String)temp);
			 try{
			 FileOutputStream FOS=new FileOutputStream(f);
			 ObjectOutputStream OOS=new ObjectOutputStream(FOS);
			 OOS.writeObject(get(temp));
			 }catch(IOException ie)
			 {
				return;
			 }

			}
		
	}
	
	/** This method clears all contents of the hashtable,
	 * it sort of erases everything
	 */
	public void erase()
	{
	    clear();
	}
	
	/** This method deletes one Element of the hashtable,
	 * it sort of erases the Object
	 */
	public void erase(Object key)
	{
	    remove(key);
	}
	    
    /** This method saves one object in Storage on Disk.
	  * The filename is the key-value in the hashtable and
	  * the Object is the value corresponding to it
	  * The keys are determined by the ItFileName Class.
	  */
	
	public void save(Object key)
	{
		File f=new File((String)key);
		try{
		    FileOutputStream FOS=new FileOutputStream(f);
		    ObjectOutputStream OOS=new ObjectOutputStream(FOS);
		    OOS.writeObject(get(key));
		}catch(IOException ie)
		{
		    return;
		}

	}
	
	/**
	  * setSaving is used to determine whether the dataPool should
	  * save all Data in storage in files at THE END of the simulation or not
	  */

	public void setSaving(boolean save)
	{
		this.save=save;
	}
}